%define module_name Redis-CappedCollection
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Const/Fast.pm) perl(Data/UUID.pm) perl(Digest/SHA1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/XS.pm) perl(List/Util.pm) perl(Mouse.pm) perl(Net/EmptyPort.pm) perl(Params/Util.pm) perl(Redis.pm) perl(Sys/SigAction.pm) perl(Test/Exception.pm) perl(Test/NoWarnings.pm) perl(Test/RedisServer.pm) perl(Time/HiRes.pm) perl(Try/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: Redis::CappedCollection module provides the fixed sized collections that have a auto-FIFO age-out f...
Group: Development/Perl
License: perl
URL: https://github.com/TrackingSoft/Redis-CappedCollection

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SG/SGLADKOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The module provides an object oriented API.
This makes a simple and powerful interface to these services.

The main features of the package are:

=over 3

=item *

Provides an object oriented model of communication.

=item *

Support the work with data structures on the Redis server.

=item *

Supports the automatic creation of capped collection, status monitoring,
updating the data set, obtaining consistent data from the collection,
automatic data removal, the classification of possible errors.

=item *

Simple methods for organizing producer and consumer clients.

=back

Capped collections are fixed sized collections that have an auto-FIFO
age-out feature (age out is based on the time of the corresponding inserted data).
With the built-in FIFO mechanism, you are not at risk of using
excessive disk space.
Capped collections keep data in their time corresponding inserted data order
automatically (in the respective lists of data).
Capped collections automatically maintain insertion order for the data lists
in the collection.

You may insert new data in the capped collection.
If there is a list with the specified ID, the data is inserted into the existing list,
otherwise it is inserted into a new list.

You may update the existing data in the collection.

Once the space is fully utilized, newly added data will replace
the oldest data in the collection.
Limits are specified when the collection is created.

Old data with the same time will be forced out in no specific order.

The collection does not allow deleting data.

Automatic Age Out:
If you know you want data to automatically "roll out" over time as it ages,
a capped collection can be an easier way to support than writing manual removal
via cron scripts.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
