# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Regexp-CharClasses-Thai
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: useful character properties f.e'or
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EM/EMUNDALL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module supplements the UTF-8 character-class definitions 
  available to regular expressions (regex) w.e'ith special groups 
  relevant to Thai linguistics.  The following classes are d.e'efined:

_.v'.a..ai.av.aa.a'.ao.v'.ve.a'.v'.a'.au.v'.ai.a'.ve.au.ae.aE.a..a'.au.a'.au.a'.aN.ai.a'.ai.aB.a..a'.aa.aB.au.ad.aN.a'.a'.ae.aO UTF-8
_.v'.a'.v'.v'.ai.v'.a'.aN.a' (regex) .a..aN.v'.ai.v'.a' .ai.v'.ai.aA.a'.aa.aa.v'.a..a'.aE.ve.aU.a.
_.a..ao.v'.ve.a'.ao.v'.aA.ai.a'.v'.ad.a'.a'.aN.a'.ao.aB.a..aB.v'.a..aA .a..ao.a'.aB.ae.a'.au.aA.a'.ai.a'.aa.aB.au.a'.v'.ad.v'.a'.a'.ao.v':

=over 4

=item InThai / IsThai

  Matches ALL characters in the Thai unicode code-point range.
  
  .a'.aN.a'.a'.av.v'.ad.aN.a'.a'.ae.aO.a..aN.v'.a'.aA.a..ai.v'.a'.a'.v'.ai.a'.a'.aa.ai.v'.a'.v'.ai.aA.av.a'.aE.v'.a'.v'.ai.ao.aB.a..aB.v'.a..aA

=item InThaiCons / IsThaiCons

  Matches Thai consonant letters, leaving out vowels (but including
  those vowels which are sometimes consonants).
  
  .a'.aN.a'.a'.av.v'.a'.aA.aN.a'.a'.a'.aO.v'.a..aA (.ae.ai.a..au.ae.aO.a..ao.v'.a'.aB.a'.a'.ae.aN.v'.a'.ve.a'.v'.a'.a'.aA.aN.a'.a'.a'.aO.ai.v'.ai.aA)

=item InThaiVowel / IsThaiVowel

  Matches Thai vowels only, including compounded and free-standing 
  vowels.  Exceptions here include several of the .e'consonants.e' which 
  also serve as vowels: o-ang, yo-yak, double ro-rua, lu and ru, and 
  wo-waen (.ad, .aA, .ae.ae, .aI, .aI, .ai), which are also included except f.e'or 
  the two-character .ae.ae.

  NOTE: Thai vowels cannot stand alone: they are always connected 
  w.e'ith a consonant.  Many of these, without their consonant 
  companions, will appear w.e'ith the unicode dotted-circle character 
  (U+25CC) when rendered, showing a character is missing.  
  Conversely, Thai consonants c.e'an exist without a vowel, and some 
  Thai words d.e'o not have written vowels (the vowel is implied).
  
  .a'.aN.a'.a'.av.v'.au.ae.aO.v'.a..aA.ve.a..v'.aB.a'.aN.v'.a' .ae.ai.a..a..aN.v'.a'.au.ae.aO.a'.ae.aO.a'.ad.a' .v'.aa.aO.au.ae.aO.ad.aE.au.ae.aO .a'.v'.ad.aA.a'...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/R*

%changelog
