# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build.pm)
# END SourceDeps(oneline)
%define module_name Regexp-Cherokee
%define _without_test 1
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Regular Expressions Support for Cherokee Script.
Group: Development/Perl
License: perl
URL: https://github.com/dyacob/Regexp-Cherokee

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DY/DYACOB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Regexp::Cherokee module provides POSIX style character class
definitions for working with the Cherokee syllabary.  The character
classes provided by the Regexp::Cherokee package correspond to inate
properties of the script and are language independent.

The Regexp::Cherokee package is NOT derived from the Regexp class
and may not be instantiated into an object.  Regexp::Cherokee can
optionally export the utility functions `getForm', `setForm', 
`subForm' and `formatForms' (or all with the `:utils' pragma)
to query or set the form of an Cherokee character.  Tags of variables
in the form names set to form values may be exported under the `:forms'
pragma.

See the files in the doc/ and examples/ directories that are included
with this package.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.md Changes LICENSE README.md CONTRIBUTING.md SECURITY.md examples
%perl_vendor_privlib/R*

%changelog
