%define module_name Regexp-Common-Markdown
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(Regexp/Common.pm) perl(Regexp/Common/Email/Address.pm) perl(Regexp/Common/URI.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(URI/tel.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.5
Release: alt1
Summary: Markdown Common Regular Expressions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module provides Markdown regular expressions as set out by its original author John Gruber

There are different types of patterns: vanilla and extended. To get the extended regular expressions, use the `-extended' switch.

You can use each regular expression by using their respective names: *Bold*, *Blockquote*, *CodeBlock*, *CodeLine*, *CodeSpan*, *Em*, *HtmlOpen*, *HtmlClose*, *HtmlEmpty*, *Header*, *HeaderLine*, *Image*, *ImageRef*, *Line*, *Link*, *LinkAuto*, *LinkDefinition*, *LinkRef*, *List*

Almost all of the regular expressions use named capture. See the section on "%%+" in the perlvar manpage for more information on named capture.

For example:

    if( $text =~ /$RE{Markdown}{LinkAuto}/ )
    {
        print( "Found https url \"$+{link_https}\"\n" ) if( $+{link_https} );
        print( "Found file url \"$+{link_file}\"\n" ) if( $+{link_file} );
        print( "Found ftp url \"$+{link_ftp}\"\n" ) if( $+{link_ftp} );
        print( "Found e-mail address \"$+{link_mailto}\"\n" ) if( $+{link_mailto} );
        print( "Found Found phone number \"$+{link_tel}\"\n" ) if( $+{link_tel} );
        my $url = URI->new( $+{link_https} );
    }

As a general rule, Markdown rule requires that the text being parsed be de-tabbed, i.e. with its tabs converted into 4 spaces. Those regular expressions reflect this principle.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes CONTRIBUTING.md
%perl_vendor_privlib/R*

%changelog
