# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define module_name Regexp-Functions-chmod_et_al
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Patterns for matching Perl functions chmod(), mkdir(), File::Path::mkpath(), File::Path::makepath()
Group: Development/Perl
License: Perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKEENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module exports on request only a single scalar, `$qr_chmod_et_al', which
is a compiled regular expression.  The regex has a very limited focus:
Searching Perl source code for instances of the following functions:

=over 4

=item * Perl built-in `chmod'

=item * Perl built-in `mkdir'

=item * `File::Path::mkpath()'

=item * `File::Path::make_path()'

=back

... and only in circumstances where a numerical mode that specifies that the
user has neither `read' nor `execute' is being supplied as an argument.
Examples of such modes:

    0000
     000
      00
       0
    0200
     200
    0222

NOTE:  This is alpha code.  This is a developer's tool and is not
intended be used in production code.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/R*

%changelog
