# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/PP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Regexp-IntInequality
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.90
Release: alt1
Summary: generate regular expressions to match integers                         greater than / less than / e...
Group: Development/Perl
License: lgpl
URL: https://github.com/haukex/re-int-ineq

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAUKEX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a single function, `re_int_ineq', which generates
regular expressions that match integers that fulfill a specified inequality
(greater than, less than, and so on). By default, only non-negative integers
are matched (minus signs are ignored), and optionally all integers can be
matched, including negative. Integers with leading zeros are never matched.

Note: Normally, this is not a task for regular expressions, instead it is
often preferable to use regular expressions or other methods to extract the
numbers from a string and then use normal numeric comparison operators.
However, there are cases where this module can be useful, for example when
embedding these regular expressions as part of a larger expression or grammar,
or when dealing with an API that only accepts regular expressions.

The generated regular expressions are valid in Perl, Python, and JavaScript
ES2018 or later, and probably in other languages that support
lookaround assertions with the same syntax.
See also.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE.txt
%perl_vendor_privlib/R*

%changelog
