# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Regexp-Log-DateRange
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: construct regexps for filtering log data by date range
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KA/KARASIK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The module was written as a hack, for the task at hand, to scan a log file and.account for the lines within a date range. The initial trivial implementation,
for the log file conducted by syslog

  Feb  4 00:00:01 moof postfix/smtpd[1138]: connect from localhost[127.0.0.1]
  Feb  4 00:00:01 moof postfix/smtpd[1138]: BED3B70625: client=localhost[127.0.0.1]

is as simple as it gets, where the line filtering condition would be written as

   /^(\w+)\s+(\d+)\s+(\d\d):(\d\d)/ and $months{lc $1} < $some_month and $2 < 15

and so on and so on, - you get the idea. That was considered not fun enough,
and instead this module was written to construct a regexp that would tell
whether a date is within a particular date range - and to do it fast, too. In
the example below it is explained how to construct something along the lines of

  (?:(?:jan|feb)\s+|mar\s+(?:(?:0?[1-9]|1[0-7])\s+|18\s+(?:0?\d|1[0-3])\:))

that matches a given date range within a single call.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/R*

%changelog
