# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(experimental.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Regexp-N_Queens
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2023021701
Release: alt1
Summary: `Regexp::N_Queens` - Solve the `N`-Queens problem by using a regular expression.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABIGAIL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Solves the `N'-Queens problem using a regular expression. The
`N'-Queens problem asks you to place `N' Queens on an 
`N x N' chess board such that no two Queens attack each other.
There are solutions for each positive `N', except for `N == 2'
and `N == 3'.

After creating the solver object with `new', and initializing it
with `init' (which takes a `size' parameter indicating the size
of the board), the solver object can be queried by the methods
`subject' and `pattern'. Matching the pattern returned by
`pattern' against the string returned by `subject' solves the
`N'-Queens problem: if there is a match, the Queens can be placed,
if there is no match, no solution exists.

If there is a match, the content of the board can be found in the
`%%+' hash: for each square `(x, y)' on the board, with
`1 <= x, y <= N', we create a key `$key = "Q_${x}_${y}"'.
We can now determine whether the field contain a Queen: if
`$+ {$key}' is true, there is a Queen on the square, else, there
is no Queen.

Note that it doesn't matter in which corner of the board you place
the square `(1, 1)', nor which direction you give to `x' and
`y', as each reflection and rotation of a solution to the
`N'-Queens problem is also a solution.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/R*

%changelog
