%define module_name Regexp-Sudoku
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/Util/FieldHash.pm) perl(List/Util.pm) perl(Math/Sequence/DeBruijn.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(experimental.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2022062101
Release: alt1
Summary: Solve Sudokus with regular expressions.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABIGAIL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module takes a sudoku (or variant) as input, calculates a subject
and pattern, such that, if the pattern is matched agains the subject,
the match succeeds if, and only if, the sudoku has a solution. And if
it has a solution `%%+' is populated with the values of the cells of
the solved sudoku.

After constructing and initializing a sudoku object using
`new' and `init' (see below), the object can be queried
with `subject' and `pattern'. `subject' returns 
a string, while `pattern' returns a pattern (as a string).

Once the subject has been matched against the pattern, 81 (or rather
`N ** 2' for an `N x N' sudoku) named captures will be set:
`R1C1' .. `R1C9' .. `R9C1' .. `R9C9'. These correspond
to the values of the cells of a solved sudoku, where the cell in the
top left is named `R1C1', the cell in the top right `R1C9',
the cell in the bottom left `R9C1' and the cell in the bottom right
`R9C9'. In general, the cell on row `r' and column `c'
is named `RrCc'. Named captures are available in `%%+'
(see the section on "%%{^CAPTURE}" in the perlvar manpage).

The `init' method takes the following named parameters:

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
