# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test/Base.pm) perl(Test/More.pm) perl(YAML/Loader.pm) perl(Test/Perl/Critic.pm)
# END SourceDeps(oneline)
%define module_version 0.61
%define module_name Religion-Bible-Regex-Config
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.61
Release: alt1
Summary: Creates a configuration object for the Religion::Bible::Regex objects from a YAML file.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HO/HOLMLUND/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Religion::Bible::Regex::Config;.
    # Initialize with a YAML file or a string containing YAML
    my $c = new Religion::Bible::Regex::Config("config.yml");

    # Retrieve configurations in YAML format    
    my $regex_configurations = $c->get_regex_configs;
    my $reference_configurations = $c->get_reference_configs;
    
    # Initialize other Religion::Bible::Regex objects
    my $r   = new Religion::Bible::Regex::Regex($c);
    my $v   = new Religion::Bible::Regex::Versification($r, $c);
    my $ref = new Religion::Bible::Regex::Reference($r, $c);
      


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
