%define module_name Require-HookChain
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Foo.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Log/ger/Level/trace.pm) perl(Log/ger/Output.pm) perl(Log/ger/Output/String.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/HiRes.pm) perl(alias/module.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.016
Release: alt1
Summary: Chainable require hook
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Require-HookChain

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you create chainable require hooks. As one already understands,
Perl lets you put a coderef or object in `@INC'. In the case of object, its
`INC' method will be called by Perl:

 package My::INCHandler;
 sub new { ... }
 sub My::INCHandler::INC {
     my ($self, $filename) = @_;
     ...
 }

The method is passed itself then filename (which is what is passed to
`require()') and is expected to return nothing or a list of up to four values:
a scalar reference containing source code, filehandle, reference to subroutine,
optional state for subroutine (more information can be read from the the perlfunc manpage
manpage). As soon as the first hook in `@INC' returns non-empty value then the
search for source code is stopped.

With `Require::HookChain', you can put multiple hooks in `@INC' that all get
executed. When `use''d, `Require::HookChain' will install its own hook at the
beginning of `@INC' which will search for source code in `@INC' as well as
execute `INC' method of all the other hooks which are instances of
`Require::HookChain::*' class. Instead of filename, the method is passed a
`Require::HookChain::r' object (`$r'). The method can do things on `$r', for
example retrieve source code via `$r->src' or modify source code via `$r->src($new_content)'. After the method returns, the next
`Require::HookChain::*' hook is executed, and so on. The final source code will
be retrieved from `$r->src' and returned for Perl.

This lets one chainable hook munge the result of the previous chainable hook.

To create your own chainable require hook, see example in the section on "SYNOPSIS". First
you create a module under the `Require::HookChain::*' namespace, then create a
constructor as well as `INC' handler.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/R*

%changelog
