%define module_name Rex-Dondley-ProcessTaskArgs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Log/Log4perl/Shortcuts.pm) perl(Rex.pm) perl(Rex/Args.pm) perl(Rex/Commands.pm) perl(Rex/Config.pm) perl(Rex/RunList.pm) perl(Rex/Transaction.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.013
Release: alt1
Summary: easier Rex task argument handling
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STEVIED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is designed to alleviate some of the pain of processing arguments
passed to tasks from the command line and from other tasks with the
`run_task()' function. Think of it as a simpler, more specialized
version of the Params::Validate manpage.

This module supplies a single function, `process_task_args', which accepts
three different types of arguments:

=over 1

=item * An array reference containing the original `@_' special variable, followed
by...

=item * A list containing the available keys and, optionally, which keys are
required, followed by...

=item * An optional array reference containing the default values in the order
corresponding to the list of available keys

=back

`process_task_args' does the following:

=over 1

=item * Ensures all required keys are given

=item * If arguments do not have associated keys on the command line, it will
assign them to the next avaiable key according to the order provided by the
available key list

=item * Replaces missing arguments with the default values, if provided

=item * Ensures no extra arguments are supplied

=item * Properly handles parameters passed via `run_task()' as an array
`run_task('some_task', params => [ 'some_value' ]);'

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/R*

%changelog
