%define module_name Rex-Virtualization-CBSD
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Rex/Commands/Fs.pm) perl(Rex/Commands/User.pm) perl(Rex/Helper/Run.pm) perl(Rex/Logger.pm) perl(Rex/Virtualization/Base.pm) perl(Term/ANSIColor.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.0
Release: alt1
Summary: CBSD virtualization module for bhyve
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Rex::Commands::Virtualization;

    set virtualization => "CBSD";
    
    vm 'create', name=>'foo',
                 'vm_os_type'=>'freebsd',
                 'vm_os_profile'=>'FreeBSD-x64-13.0',
                 'vm_ram'=>'1g',
                 'vm_cpus'=>'1',
                 'imgsize'=>'10g';
    
    vm 'start' => 'foo';
    
    # list the basic settings for the VM foo from the VM list
    my %%vm_list = vm 'list';
    print Dumper \%%{ $vm_list{foo} };
    
    # get all the config info for the VM foo and display it
    %%vm_info=vm 'info' => 'foo';
    foreach my $vm_info_key (@{keys(%%vm_info)}){
        print $vm_info_key.": ".$vm_info{$vm_info_key}."\n";
    }

    # stop the VM foo
    vm 'stop' => 'foo';
    
    # remove the VM foo
    vm 'remove' => 'foo';
    
    # show all VM
    my %%vm_list = vm 'list';
    print Dumper \%%vm_list;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/R*

%changelog
