%define module_version 1.1103
%define module_name SNMP-Effective
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POSIX.pm) perl(Parse/CPAN/Meta.pm) perl(SNMP.pm) perl(Test/More.pm) perl(Tie/Array.pm) perl(Time/HiRes.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1103
Release: alt1
Summary: An effective SNMP-information-gathering module
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OL/OLIVER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module collects information, over SNMP, from many hosts and many OIDs,.really fast.

It is a wrapper around the facilities of `SNMP.pm', which is the Perl
interface to the C libraries in the `SNMP' package. Advantages of using
this module include:

=over 4

=item Simple configuration

The data structures required by `SNMP' are complex to set up before
polling, and parse for results afterwards. This module provides a simpler
interface to that configuration by accepting just a list of SNMP OIDs or leaf
names.

=item Parallel execution

Many users are not aware that `SNMP' can poll devices asynchronously
using a callback system. By specifying your callback routine as in the
the section on "SYNOPSIS" section above, many network devices can be polled in parallel,
making operations far quicker. Note that this does not use threads.

=item It's fast

To give one example, `SNMP::Effective' can walk, say, eight indexed OIDs
(port status, errors, traffic, etc) for around 300 devices (that's 8500 ports)
in under 30 seconds. Storage of that data might take an additional 10 seconds
(depending on whether it's to RAM or disk). This makes polling/monitoring your
network every five minutes (or less) no problem at all.

=back

The interface to this module is simple, with few options. The sections below
detail everything you need to know.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/S*

%changelog
