# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Compare.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Tk.pm) perl(Tk/Dialog.pm) perl(Tk/FBox.pm) perl(Tk/Tree.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name SNMP-MIB-Compiler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: a MIB Compiler supporting SMIv1 and SMIv2
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FT/FTASSIN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
SNMP::MIB::Compiler is a MIB compiler that fully supports
    both SMI(v1) and SMIv2. This module can be use to compile
    MIBs (recursively or not) or load already compiled MIBs for
    later use.
    Some tasks can be performed by the resulting object such as :

      - resolution of object names into object identifiers (OIDs).
        e.g. ifInOctets => 1.3.6.1.2.1.2.2.1.10

      - convertion of OIDs.
        e.g. 1.3.6.1.2.1.2.1 =>
               iso.org.dod.internet.mgmt.mib-2.interfaces.ifNumber

      - drawing MIB trees.
        e.g. ifTestTable => ifTestTable
                                |
                                +-- --- ifTestEntry(1)
                                    |
                                    +-- -rw Integer  ifTestId(1)
                                    +-- -rw Integer  ifTestStatus(2)
                                    +-- -rw ObjectID ifTestType(3)
                                    +-- -r- Integer  ifTestResult(4)
                                    +-- -r- ObjectID ifTestCode(5)
                                    +-- -rw String   ifTestOwner(6)


    The MIB to be compiled requires no modification. Everything legal
    according to SMIs is accepted, including MACRO definitions (which
    are parsed but ignored).

    This module is shipped with the basic MIBs usually needed by IMPORTS
    clauses. A lot of IETF MIBs has been successfully tested as well as
    some private ones.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/S*
%perl_vendor_privlib/B*

%files scripts
%_bindir/*

%changelog
