# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(DBI.pm) perl(Data/Compare.pm) perl(Exporter.pm) perl(FindBin.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Parse/RecDescent.pm) perl(Pod/Usage.pm) perl(SQL/Abstract.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version v0.5.0
%define module_name SQL-Admin
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5.0
Release: alt1
Summary: Maintain database schemas
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BARNEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use SQL::Admin;

   # Merge multiple SQL files
   my $catalog = SQL::Admin
      ->get_catalog
      ->load ('DB2', { file => [ 'create-schema.sql', 'update-001.sql' ] })
      ->save ('Pg', { file  => [ 'output.sql' ] });

   # ... deploy catalog
   $catalog->save ('Pg::DBI', { dbdsn  => ... });


   # Sync SQL files and db
   my $src = SQL::Admin->get_catalog;
      ->load ('Pg::DBI', { dbdsn => ... });

   my $dst = SQL::Admin->get_catalog;
      ->load ('Pg', { file => [ 'create-schema.sql' ] });

   my $diff = SQL::Admin->compare ($src, $dst);

   if ($diff->is_difference) {
       $diff->save ('Pg');
       $diff->save ('Pg::DBI', { dbdsn => ... });
   }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/S*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
