Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/Scalar.pm) perl(Log/Trace.pm) perl(Pod/Select.pm) perl(Pod/Usage.pm) perl(Term/ReadKey.pm) perl(Term/ReadLine.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_SQL_Shell_enables_optional_test

Name:       perl-SQL-Shell 
Version:    1.17
Release:    alt2_16
# lib/SQL/Shell.pm: GPLv2+
# bin/sqlsh:        GPLv2+
# README:           GPLv2+
# COPYING:          GPLv2 text (old FSF address, see CPAN RT#112335)
License:    GPLv2+
Summary:    Command interpreter for DBI shells 
Url:        https://metacpan.org/release/SQL-Shell
Source:     https://cpan.metacpan.org/authors/id/M/MG/MGUALDRON/SQL-Shell-%{version}.tar.gz
BuildArch:  noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
%if %{with perl_SQL_Shell_enables_optional_test}
BuildRequires:  perl(CGI.pm)
%endif
# Config not used at tests
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(File/Path.pm)
# Getopt::Long not used at tests
BuildRequires:  perl(IO/File.pm)
# IO::Scalar not used at tests
%if %{with perl_SQL_Shell_enables_optional_test}
BuildRequires:  perl(Locale/Recode.pm)
%endif
# Log::Trace not used at tests
# Pod::Select not used at tests
# Pod::Usage not used at tests
BuildRequires:  perl(strict.pm)
# Term::ReadKey not used at tests
# Term::ReadLine not used at tests
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(vars.pm)
# Tests:
BuildRequires:  perl(IO/CaptureOutput.pm)
BuildRequires:  perl(Test/Assertions/TestScript.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_SQL_Shell_enables_optional_test}
# Optional tests:
BuildRequires:  perl(DBD/SQLite.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:   perl(CGI.pm)
Requires:   perl(Locale/Recode.pm)
Source44: import.info

%description
SQL::Shell is a command-interpreter API for building shells and batch
scripts. A command-line interface with readline support is included 
as part of the CPAN distribution. See SQL::Shell::Manual for a user
guide. SQL::Shell offers features similar to the mysql or sql*plus
client programs but is database independent.

This package provides the backend SQL::Shell libraries.  For the 
command-line interpreter (sqlsh), please also install the sqlsh package.

%package -n sqlsh
Group: Development/Other
Summary:    Command interpreter for DBI shells
Requires:   %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:   perl(IO/Scalar.pm)
Requires:   perl(Pod/Select.pm)
# Term::ReadLine::Gnu for GetHistory(), bug #707442
Requires:   perl(Term/ReadLine/Gnu.pm)

%description -n sqlsh
sqlsh is a command-interpreter API for building shells and batch
scripts. sqlsh/SQL::Shell offers features similar to the mysql or 
sql*plus client programs but is database independent.

See the SQL::Shell::Manual manual page for a user guide.

%prep
%setup -q -n SQL-Shell-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
unset ORACLE_HOME PERL_READLINE_MODE
export UNIT_TEST_DSN='DBI:SQLite:dbname=test.db'
export UNIT_TEST_USER='anything'
export UNIT_TEST_PASS=''
make test

%files
%doc --no-dereference COPYING
%doc Changes README
%{perl_vendor_privlib}/*

%files -n sqlsh
%{_bindir}/sqlsh
%{_mandir}/man1/sqlsh.1*

%changelog
