# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name SQL-String
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: An object representation of a chunk of SQL
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
SQL::String is a simple object class that lets you create "chunks" of SQL
that intrinsicly have their parameters attached to them.

Quite a few standard SQL queries won't need this, you create your main
select statement once, and then provide the parameters different for each
call.

However, several types of queries can benefit from this. In particular,
the creation of large and complex search queries can be tricky to build
what might be 1000 character of SQL and keep track of all the required
parameters (short of doing them in a named form, with all the problems
of namespace management that entails).

SQL::String solves this problem by embedding the parameters into the SQL.

A SQL::String object exists as a reference to an array containing the SQL,
and a number of parameters intended to be used with it.

More usefully, SQL::String overloads concatonation so that you can still
use a SQL::String object naturally is if it was just SQL.

Once you have created your large complex query, you simple split out the
SQL and parameters parts and hand them off to DBI normally.

Although SQL::String WILL check to make sure that the SQL is a simple string
of at least one character, it makes no judgements whatsoever about the
parameters. `undef', references, objects, everything is legal.

This enables custom database backends that do translation of non-DBI
parameters normally.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/S*

%changelog
