# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Extract.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Parse/CSV.pm) perl(SQL/Script.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name SQLite-Archive
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Version-agnostic storage and manipulation of SQLite databases
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
SQLite (and the Perl module for it the DBD::SQLite manpage) is an extremely handy
database for storing various types of simple information.

However, as SQLite has developed, the binary structure of the SQLite
database format itself has changed and evolved, and continues to change
and evolve. As new releases come out, new versions of the DBD::SQLite manpage are
also released with matching code.

This makes SQLite database files suboptimal (at best) for use in
distributing data sets between disparate systems.

At the same time, a giant raw .sql script says very little about the
data itself (such as which database and version it is intended for),
requires a client front end to throw the SQL script at, and it not
easily editable or manipulatable while dumped.

SQLite::Archive provides a straight forward mechanism for exporting
(and importing) SQLite databases, and moving that data around as a
single file to (or from) other hosts.

It uses a regular tar archive, with the data stored in CSV files, and
the table structure stored in a create.sql file.

Given a SQLite archive file (SQLite::Archive will take anything
supported by the Archive::Extract manpage) it will extract the tarball to a
temporary directory, create a SQLite database (in a location of your
choice or also in a temp directory) and then populate the SQLite
database with the data from the archive.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/S*

%changelog
