# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Meta.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 SQLite-Work
%define upstream_version 0.16

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    0.1601
Release:    alt1

Summary:    A Perl module to report on and update an SQLite database
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RU/RUBYKAT/SQLite-Work-%{version}.tar.gz

BuildRequires: perl(CGI.pm)
BuildRequires: perl(DBI.pm)
BuildRequires: perl(DBD/SQLite.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Getopt/ArgvFile.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(POSIX.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Text/NeatTemplate.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This generates HTML (and non-HTML) reports from an SQLite database, taking care
of the query-building and the report formatting. This also has methods for
adding and updating the database.

The SQLite::Work::CGI module has extra methods which deal with CGI using the
CGI module; the included "show.cgi" and "edit.cgi" are demonstration CGI
scripts which use the SQLite::Work::CGI module.

The sqlreport script uses SQLite::Work to generate reports from the
command-line.

%prep
%setup -q -n SQLite-Work-%{version}
find . -type f | xargs chmod +w

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc Changes LICENSE META.yml README.pod
%{perl_vendor_privlib}/SQLite
%{_mandir}/*/*
%{_bindir}/*


%changelog
