%define module_name SQS-Worker
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(Log/Log4perl.pm) perl(MIME/Base64.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(MooseX/Getopt.pm) perl(Paws.pm) perl(SNS/Notification.pm) perl(Storable.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Spec.pm) perl(if.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: A light framework for processing messages from SQS queues
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JL/JLMARTIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
SQS::Worker is a light framework that allows you to just code asyncronous tasks
that consume messages from an SQS Queue. The framework takes care of launching the 
necessary processes (workers), and executes your code on incoming messages, so you
can focus on writing the important part (behavior)

Also, since you're surely going to be deserializing the messages that come from the
queue, SQS::Worker provides you with ways to easily consume JSON messages, for example.

It comes in the form of a Moose role that is to be composed into the end user code 
that wants to receive and process messages from an SQS queue. 

The worker runs uninterrumped, fetching messages from it's configured queue, 
one at a time and then executing the process_message of the worker class.

The worker consumer can compose further funcionality by consuming more roles 
from the SQS::Worker namespace.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changelog
%perl_vendor_privlib/S*

%files scripts
%_bindir/*

%changelog
