# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Parse/Binary/FixedFormat.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name STANAG
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Library for processing STANAG 4586 messages
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CA/CAJ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use STANAG qw(Get_Vehicle_Name Get_Vehicle_Subtype);.
    use strict;
    use warnings;
    use Data::Dumper;

    my $hashref = STANAG::Vehicle_ID(); #get blank hash

    $hashref->{Vehicle_Type} = 22; #stick in some sample data
    $hashref->{Vehicle_Subtype} = 101;

    print Dumper($hashref); #see what's in it

    my $flat = STANAG::Encode_Vehicle_ID($hashref); #package up for sending (computes xsums)
    my $hashref2 = STANAG::Decode_Vehicle_ID($flat); #unpackage into hash (checks xsums)

    my $hashref3 = STANAG::Vehicle_ID(); #grab a new hash with latest used values
                                         #so this one gets the values we put into $hashref

    print Dumper($hashref2); 
    print Dumper($hashref3); #these print the same thing

    print Get_Vehicle_Name($hashref2->{Vehicle_Type}),"\n"; #demo decoding some numeric codes.
    print Get_Vehicle_Subtype($hashref2->{Vehicle_Subtype}),"\n";


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*
%changelog
