%define module_name SVG-Estimate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(Image/SVG/Path.pm) perl(Image/SVG/Transform.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Math/Trig.pm) perl(Moo.pm) perl(Ouch.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(XML/Hash/LX.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0116
Release: alt1
Summary: Estimates the length of all the vectors in an SVG file.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/COLINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
SVG::Estimate is a suite of modules that allow you to accurately estimate the length of the vectors inside of a Scalable Vector Graphics (SVG) file. It is only an estimate because we lack the math to give absolutely precise lengths of really complex curves in a time-efficient manner. Therefore, we take guesses in some cases, though those guesses are still quite accurate (to within about 0.1%%). In a battery of tests against our own equipment, our measurements were more accurate than those provided by the equipment itself. 

This is highly useful for any 2 dimensional CNC machines that use vector files to create tool paths, as you may want to know how long a job will take to quote your customer.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/S*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
