%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(SVN/Core.pm) perl(SVN/Fs.pm) perl(SVN/Repos.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name SVN-TXN-Props
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Provides a hash interface to Subversion transaction properties
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CL/CLEISHMAN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Maps properties from a subversion transaction to a hash.  This allows for
reading and manipulating properties of active subversion transactions before
the transaction is commited, for example during a pre-commit hook script.

This module provides a tied hash interface, allowing it to be used with the
perl tie function, eg:

  use SVN::TXN::Props;
  tie %%props, 'SVN::TXN::Props', $repository_path, $txn_name;
  $props{'svn:author'} = 'nobody';

The arguments to the tie function can either be the path to a repository
and the name of a transaction, or an already open transaction object:

  my $txn = SVN::Repos::open($repository_path)->fs->open_txn($txn_name);
  tie %%props, 'SVN::TXN::Props', $txn;

Alternatively, the function get_txn_props can be imported, which will
returned an already tied hash reference, eg:

  use SVN::TXN::Props qw(get_txn_props);
  my $props = get_txn_props($repository_path, $txn_name);
  $props->{'svn:author'} = 'nobody';

As with the tie call, a single open transaction object can be passed 
to get_txn_props instead of the repository_path and txn_name.

The underlying SVN::TXN::Props object is returned by the tie call, or
can be obtained from the tied hash using the perl tied() function.  This
provides a single method txn() that will return the underlying subversion
transaction object, eg:

  my $txn_props = tie %%props, 'SVN::TXN::Props', $repository_path, $txn_name;
  my @paths = keys %%{$txn_props->txn->root->paths_changed()};


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%changelog
