%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Proc/Info/Environment.pm) perl(Proc/ProcessTable.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name SVN-Utils-ClientIP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Get the client's IP address in a Subversion Hook
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
SVN::Utils::ClientIP solves the age-old problem of obtaining the SSH 
client's IP address in a commit hook of a Subversion repository. 

Knowing the client's IP address can be quite useful in heavily used 
Subversion installations, as it allows for maintaining a log on who 
accessed a repository when and from where.

However, the Subversion developers are not very accomodating when it 
comes to this, claiming "security purposes":

   http://svn.haxx.se/users/archive-2009-02/0804.shtml

But, if you think about how a client connects to the repository using
SSH, which then spawns the svn process, it becomes quite clear how you
can get the IP address, even if the Subversion folks are hiding it from
you: Starting from the currently running hook, walk up the process 
hierarchy, until you reach the parent that's the SSH instance serving the 
client (only tested with openssh). In its environment, you'll find a 
variable named SSH_CLIENT, which contains the IP address of the connecting
client.

This is exactly what this module does, and you can simply obtain the
SSH client's IP address by running

    use SVN::Utils::ClientIP qw(ssh_client_ip);

    my $ip = ssh_client_ip();

Under the hood, the module uses the CPAN modules Proc::ProcessTable
for obtaining the ppid() to walk up the process hierarchy and
Proc::Info::Environment for reading out the SSH_CLIENT environment
variable. By the time of this writing, the latter only worked for
Linux, but in the meantime other OSes might be supported.

It's not terribly expensive, but it adds up and if you're using the 
function many times, you might want to memoize() it.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
