%define module_name Scalar-Cmp
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Compare two scalars
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Scalar-Cmp

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides the cmp_scalar entry elsewhere in this document (and the cmpnum_scalar entry elsewhere in this document and
the cmpstrornum_scalar entry elsewhere in this document which are convenient routines to compare two scalar
values (ii.e. check if they are the same, or find out who is "greater than" the
other). The routines can handle `undef' and references, so you don't have to
manually check for these.

The routines return -1, 0, 1 like Perl's `cmp' and `<=>' operators, but
also possibly `2' when the two scalars are different but there is no sensible
notion of which one is larger than the other (e.g. `1' vs `[1]'). The
following is the rule:

=over

=item 1. Defined value is greater than undef.

 cmp_scalar(undef, 0); # => -1

=item 2. undef is the same as itself.

 cmp_scalar(undef, undef); # => 0

Note: This might not be what you want if you expect `undef' to act like `NULL'
in relational databases, where `NULL' is not equal to itself.

=item 2. References cannot be compared with non-references.

 cmp_scalar(1, []); # => 2
 cmp_scalar([], 1); # => 2

=item 3. A reference is only the same as itself, otherwise it cannot be compared.

 cmp_scalar([], []); # => 2

 my $ary = [];
 cmp_scalar($ary, $ary); # => 0, same "address"

=item 4. Non-references are compared with `cmp' or `<=>'

the cmp_scalar entry elsewhere in this document always uses `cmp'. the cmpnum_scalar entry elsewhere in this document always uses `<=>'.
the cmpstrornum_scalar entry elsewhere in this document uses `<=>' if both scalars look like number, or
`cmp' otherwise.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/S*

%changelog
