# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0_2
%define module_name ScatterPlot
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0_2
Release: alt1
Summary: Perl extension for drawing ASCII scatter plots
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IN/INVENTOR/%{module_name}-%{module_version}.tgz
BuildArch: noarch

%description
This module will draw a quick and easy ASCII scatter plot.  It has only two functions, new() and draw().  new() takes no arguments and creates a new ScatterPlot object.  draw() can be called with no arguments to draw a sample test plot.  You can call draw like this:  

    draw($xy_points);

where $xy_points is a reference to an array of (x,y) pairs.  See the file ScatterPlot.pl for an example.  The full call to draw is: 

    draw($xy_points, $x_size, $y_size, $x_label, $y_label, $char, $type);

where $xy_points is a reference to an array of (x,y) pairs, $x_size is an integer describing the width of the plot in characters, $y_size is an integer describing the height of the plot in characters, $x_label is a string for the horizontal axis label, $y_label is a string for the vertical axis lable, $char is the plot character, and $type is either 'text', 'html', or 'HTML'.  If you are using CGI or sending the plot output to a web page, then use $type='html' or $type='HTML'.  

The method draw() will automatically scale the plot to fit your data and draw the axes labels accordingly.  The size of the output text will be $y_size lines of text, each of which is $x_size long in characters (plus line terminator).  In text mode the plot begins with "\n" and ends with "\n", while in html mode the plot begins with "<pre>" and ends with "<\pre>".  


%prep
%setup -n Text
# depth is > 1 .. moving up
pushd "Graph/ScatterPlot"
  mv -f * ../../
  mv -f .* ../../ ||:
popd
rm ScatterPlot.pl

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
