%define module_name School-Code-Compare
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Rule.pm) perl(File/Slurp.pm) perl(IO/Prompt/Simple.pm) perl(Module/Installed/Tiny.pm) perl(Module/Load.pm) perl(OptArgs.pm) perl(Template.pm) perl(Test/More.pm) perl(Test/Script.pm) perl(Text/Levenshtein/XS.pm) perl(feature.pm) perl(if.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.201
Release: alt1
Summary: 'naive' metrics for code similarity
Group: Development/Perl
License: perl
URL: https://gitlab.com/borisdaeppen/School-Code-Compare

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BO/BORISD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution ships a script.
You migth want to look at the script the compare-code manpage in the `bin' directory.
For documentation of the used libraries, keep on reading.

This calculates the Levenshtein Difference for two files, if they meet certain criterias:

 use School::Code::Compare;

 my $comparer   = School::Code::Compare->new()                                    
                                       ->set_max_char_difference(400)             
                                       ->set_min_char_total     ( 20)             
                                       ->set_max_distance       (400);
 
 my $comparison = $comparer->measure( 'use strict; print "Hello\n";',
                                      'use v5.22; say "Hello";'
                                    ); 

 print $comparison->{distance} if $comparison   # 13

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes help.txt README.md doc
%perl_vendor_privlib/S*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
