# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/CallChecker.pm) perl(Exporter.pm) perl(ExtUtils/CBuilder.pm) perl(Lexical/Import.pm) perl(Module/Build.pm) perl(Scope/Cleanup.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Scope-Escape
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt5
Summary: reified escape continuations
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZE/ZEFRAM/%{module_name}-%{version}.tar.gz

%description
This module provides a generalised facility for non-local control transfer
(jumping between stack frames), based on the well-thought-out semantics
of Common Lisp.  It provides operators that will capture and reify the
escape (return) continuation of the current stack frame.  The stack frame
can then be returned from, at (nearly) any time while it still exists,
via the reified continuation.  This applies not only to subroutine stack
frames, but also to intermediate frames for code blocks, and other kinds
of stack frame.  This facility can be used directly, or wrapped up to
build a more structured facility, as is done by the Scope::Escape::Sugar manpage.

The system of reified escape continuations is fundamentally different
from Perl's native `eval'/`die' exception facility.  With `die',
the code initiating the non-local transfer has no control over where
it will go to.  Each `eval' frame gets to decide whether it wants
to act as the target of the thrown exception, but it must make this
decision based almost entirely on what was recorded in the exception
object, because the stack frames between the `die' and the `eval'
have already been unwound by that time.  With reified continuations,
however, the code initiating the transfer determines where it will go to
(by choosing which continuation to use), and that decision can be made
with all information about the circumstances still available.

A reified escape continuation appears in Perl as a function object.
Calling the function results in returning from the stack frame that is the
target of the continuation.  Values passed to the function are returned
from the target stack frame.  Optionally, the continuation may be blessed
into the the Scope::Escape::Continuation manpage class.  This class provides a
method-based interface to the continuation: transferring through the
continuation, and querying its state, can be performed by method calls
on the continuation object.  The methods can also be called directly,
as functions, on unblessed continuation functions.
...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/S*
%perl_vendor_autolib/*

%changelog
