# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(Data/Dump.pm) perl(Dezi/App.pm) perl(Dezi/Indexer/Doc.pm) perl(Dezi/Lucy/Indexer.pm) perl(Dezi/Lucy/Searcher.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(Lucy/Object/BitVector.pm) perl(Lucy/Search/Collector/BitCollector.pm) perl(LucyX/Suggester.pm) perl(Moose.pm) perl(Path/Class.pm) perl(Path/Class/Dir.pm) perl(Scalar/Util.pm) perl(Search/OpenSearch.pm) perl(Search/Query/Dialect/Lucy.pm) perl(Search/Tools.pm) perl(Test/LeakTrace.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(Type/Tiny.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define module_version 0.400
%define module_name Search-OpenSearch-Engine-Lucy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.400
Release: alt1
Summary: Lucy server with OpenSearch results
Group: Development/Perl
License: perl
URL: https://github.com/karpet/search-opensearch-engine-lucy-perl

Source0: http://cpan.org.ua/authors/id/K/KA/KARMAN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Search::OpenSearch::Engine::Lucy;
 my $engine = Search::OpenSearch::Engine::Lucy->new(
    index       => [qw( path/to/index1 path/to/index2 )],
    facets      => {
        names       => [qw( color size flavor )],
        sample_size => 10_000,
    },
    fields      => [qw( color size flavor )],   # result attributes in response
    indexer_config  => {
        somekey => somevalue,
    },
    searcher_config => {
        anotherkey => anothervalue,
    },
    suggester_config => {
        spellcheck_config => {
            lang => 'en_US',
        },
        limit => 10,
    },
    aggregator_class => 'MyAggregator', # defaults to Dezi::Aggregator
    cache           => CHI->new(
        driver           => 'File',
        dir_create_mode  => 0770,
        file_create_mode => 0660,
        root_dir         => "/tmp/opensearch_cache",
    ),
    cache_ttl       => 3600,
    do_not_hilite   => [qw( color )],
    snipper_config  => { as_sentences => 1, strip_markup => 1, }, # see Search::Tools::Snipper
    hiliter_config  => { class => 'h', tag => 'b' }, # see Search::Tools::HiLiter
    parser_config   => {},                           # see Search::Query::Parser
    
 );
 my $response = $engine->search(
    q           => 'quick brown fox',   # query
    s           => 'score desc',        # sort order
    o           => 0,                   # offset
    p           => 25,                  # page size
    h           => 1,                   # highlight query terms in results
    c           => 0,                   # count total only (same as f=0 r=0)
    L           => 'field|low|high',    # limit results to inclusive range
    f           => 1,                   # include facets
    r           => 1,                   # include results
    t           => 'XML',               # or JSON
    u           => 'http://yourdomain.foo/opensearch/',
    b           => 'AND',               # or OR
 );
 print $response;
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
