%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/CBC.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Test/More.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Secret-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Secure secrets in configurations and code
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AG/AGF/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a straightforward interface for encrypting and
decrypting secret information such as user IDs and passwords (e.g.
database connection or remote account credentials). `Secret::Simple'
can also be used on a limited basis to protect arbitrary data. By
default the ciphertext returned is Base 64 encoded so as to be easily
embedded within configurations or scripts. A command-line utility called
`sstool' is included to facilitate easy manipulation of cipher and
plaintext snippets.

The encryption mechanism utilizes the strong AES algorithm, so any
weaknesses in `Secret::Simple' predominantly lie in how keys are
protected. A balance must be struck between key accessibility, key
protection, and overall complexity. The calling code can supply a key,
series of keys, key files, or a combination. If no key information is
explicitly passed, the module will attempt to use the OS user's private
SSH DSA key file by default if it exists.

The major goal of this module is to be as secure as possible while
being simple and convenient enough to encourage its use. Psychology does
factor in: *simple* is a very important consideration. If the security
methods are too onerous or complicated to use, many sysadmins or
developers may simply use plaintext (no protection other that OS file
permissions) or simple ciphers like rot13. The security of the
`Secret::Simple' method is not perfect, but it does represent a
significant improvement over commonly-used nonsecure methods of
embedding credentials and other secrets in Perl configurations and
scripts. If used appropriately, `Secret::Simple' can greatly improve
application and configuration security. Even so, care must always be
taken to protect files and file permissions.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
