Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Perl binding of Sendmail Milter protocol
Name:		perl-Sendmail-PMilter
Version:	1.27
Release:	alt1_1
License:	BSD-3-Clause
URL:		https://metacpan.org/release/Sendmail-PMilter
Source0:	https://cpan.metacpan.org/authors/id/G/GW/GWHAYWOOD/Sendmail-PMilter-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	sed
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(constant.pm)
BuildRequires:	perl(Errno.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(IO/Select.pm)
BuildRequires:	perl(IO/Socket/INET.pm)
BuildRequires:	perl(IO/Socket/IP.pm)
BuildRequires:	perl(IO/Socket/UNIX.pm)
BuildRequires:	perl(parent.pm)
BuildRequires:	perl(POSIX.pm)
BuildRequires:	perl(Socket.pm)
BuildRequires:	perl(Socket6.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Symbol.pm)
BuildRequires:	perl(Thread/Semaphore.pm)
BuildRequires:	perl(threads.pm)
BuildRequires:	perl(threads/shared.pm)
BuildRequires:	perl(Time/HiRes.pm)
BuildRequires:	perl(UNIVERSAL.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(Test/More.pm)
# Dependencies
Requires:	perl(IO/Socket/INET.pm)
Requires:	perl(IO/Socket/IP.pm)
Requires:	perl(IO/Socket/UNIX.pm)
Requires:	perl(Socket6.pm)
Requires:	perl(Thread/Semaphore.pm)
Requires:	perl(threads.pm)
Requires:	perl(threads/shared.pm)
Source44: import.info

%description
Sendmail::PMilter is a mail filtering API implementing the Sendmail milter
protocol in pure Perl. This allows Sendmail servers (and perhaps other MTAs
implementing milter) to filter and modify mail in transit during the SMTP
connection, all in Perl.

It should be noted that PMilter 0.90 and later is NOT compatible with
scripts written for PMilter 0.5 and earlier.  The API has been reworked
significantly, and the enhanced APIs and rule logic provided by PMilter
0.5 and earlier has been factored out for inclusion in a separate package
called Mail::Milter.

%prep
%setup -q -n Sendmail-PMilter-%{version}

# Fix interpreters in examples and turn off exec bits to avoid extra deps
sed -i -e 's@/usr/local/bin/perl@/usr/bin/perl@' examples/*.pl
chmod -c -x examples/*.pl

%build
# Using "echo" to bypass the interactive 'yes/no' question in Makefile.PL
echo yes | perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test

%files
# Note: COPYRIGHT file is identical to LICENSE file
%doc --no-dereference LICENSE
%doc ABOUT ACKNOWLEDGEMENTS Changes CONTRIBUTING README README.%{version} TODO
%doc examples/
%{perl_vendor_privlib}/Sendmail/

%changelog
