Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-ServiceNow-API
Version:        1.01
Release:        alt2_34
Summary:        ServiceNow API for accessing the Service-now platform

License:        ASL 2.0
URL:            http://wiki.servicenow.com/index.php?title=Perl_API
Source0:        http://wiki.servicenow.com/images/e/e5/ServiceNow-Perl-API.zip
Patch0:         0001-Skip-broken-POD-from-coverage-testing.patch

BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(SOAP/Lite.pm)
BuildRequires:  perl(Crypt/SSLeay.pm)
BuildRequires:  perl(IO/Socket/SSL.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(MIME/Types.pm)
BuildRequires:  perl(MIME/Type.pm)
BuildRequires:  perl(MIME/Base64.pm)


Source44: import.info

%description
The Perl API provides a library of Perl classes and sub routines
for programmatic access to the platform and its applications.
The API utilizes the SOAP web service interface of the platform.

%prep
%setup -q -c -n %{name}-%{version}
%setup -D -T -q -n %{name}-%{version}/ServiceNow-%{version}
%patch0 -p1

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name '*.bs' -a -size 0 -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name '.DS_Store' -exec rm -f {} ';'
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*

%check
make test

%files
%doc README Changes
%{perl_vendor_privlib}/*

%changelog
