%define module_name Set-Bag
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.012
Release: alt2
Summary: bag (multiset) class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAVIDO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements a simple bag (multiset) class.

A bag may contain one or more instances of elements.  One may add and
delete one or more instances at a time.

If one attempts to delete more instances than there are to delete
from, the default behavious of delete is to raise an exception.
The over_delete method can be used to control this behaviour.

Inserting or removing negative number of instances translates into
removing or inserting positive number of instances, respectively.

The sum is also known as the *additive union*.  It leaves in
the result bag the sum of all the instances of all bags.

Before using the difference you very often will need the over_delete.

The union is also known as the *maximal union*.  It leaves in
the result bag the maximal number of instances in all bags.

The intersection leaves in the result bag only the elements that
have instances in all bags and of those the minimal number of instances.

The complement will leave in the result bag the maximal number of
instances *ever* seen (via new, insert, sum, or maximize)
in the bag minus the current number of instances in the bag.

The grab method returns the contents of a bag.
If used with parameters the parameters are the elements and their
number of instances in the bag are returned.  If an element that
does not exist in the bag is grabbed for,
the number of instances returned for that element will be `undef'.
If used without parameters the elements are returned in pseudorandom order.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO README COPYRIGHT Changes
%perl_vendor_privlib/S*

%changelog
