# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/NTLM.pm) perl(CopyTree/VendorProof.pm) perl(ExtUtils/MakeMaker.pm) perl(LWP/Debug.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(SOAP/Lite.pm) perl(Test/More.pm) perl(base.pm) perl(Term/ReadKey.pm)
# END SourceDeps(oneline)
%define module_version 0.0013
%define module_name SharePoint-SOAPHandler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0013
Release: alt1
Summary: Perl extension for providing a Sharepoint connecter instance for CopyTree::VendorProof.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DB/DBMOLESTA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
SharePoint::SOAPHandler provides different types of methods.  .
First, it provides connection methods to allow us to connect to sharepoint.  These connection methods that you see in the SYNOPSIS are pretty self explanatory. 

Second, SharePoint::SOAPHandler provides methods for its parent class (CopyTree::VendorProof), which includes

	new
	fdls				
	is_fd
	read_info_memory
	write_from_memory
	copy_local_files
	cust_mkdir
	cust_rmdir
	cust_rmfile

The functionality of these methods are described in 

perldoc CopyTree::VendorProof 

Under the section "Object specific instance methods for the base class CopyTree::VendorProof"

It is worth nothing that fdls comes in quite handy for testing whether you can actually connect to your sharepoint resource using this module.  Simply open up your web browser and go to your sharepoint site, and fdls any directory that you can see under Shared Documents.  If you do a Dumper print, you should have a list of files and dirs.

	use Data::Dumper;
	print Dumper $soaphandler_inst -> fdls('', 'Shared Documents');

Lastly, SharePoint::SOAPHandler also provides methods for interacting with sharepoint's getlistcollection items.  These sharepoint methods are not extensively tested and are not supported, nor is it documented here.  To tell the truth, not all methods are *entensively* tested, but with these you are especially on your own.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
