Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Algorithm/Dependency/Ordered.pm) perl(Algorithm/Dependency/Source/HoA.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Parser.pm) perl(Pod/Select.pm) perl(Pod/Simple.pm) perl(Pod/Usage.pm) perl(Tie/File.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^perl.CPAN.Config.pm./d
%filter_from_requires /^perl.CPAN.MyConfig.pm./d
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Shipwright
Version:        2.4.42
Release:        alt2_20
Summary:        Build and Manage Self-contained Software Bundle
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Shipwright
Source0:        https://cpan.metacpan.org/authors/id/S/SU/SUNNAVY/Shipwright-%{version}.tar.gz
# Drop useless build-time feautures
Patch0:         Shipwright-2.4.41-Disable-author-test-and-network-installation-when-bu.patch
# Use real interpreter path instead of /usr/bin/env trampoline
Patch1:         Shipwright-2.4.41-Do-not-use-usr-bin-env.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/Scripts.pm)
BuildRequires:  perl(Module/Install/Share.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time:
# Algorithm::Dependency::Ordered not used at tests
# Algorithm::Dependency::Source::HoA not used at tests
BuildRequires:  perl(App/CLI.pm)
# 0.47 is broken, fixed in 0.48
BuildConflicts: perl(App::CLI) = 0.47
BuildRequires:  perl(App/CLI/Command.pm)
BuildRequires:  perl(App/CLI/Command/Help.pm)
BuildRequires:  perl(Archive/Extract.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Accessor/Fast.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(CPAN.pm)
# CPAN::Config is optional
BuildRequires:  perl(CPAN/DistnameInfo.pm)
# CPAN::MyConfig is optional
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Basename.pm)
# File::Compare not used at tests
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Copy/Recursive.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Slurp.pm)
# File::Spec not used at tests
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(File/Which.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IPC/Cmd.pm)
BuildRequires:  perl(IPC/Run3.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Log/Log4perl.pm)
# LWP::UserAgent not used at tests
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Module/CoreList.pm)
BuildRequires:  perl(Module/Info.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
# Tie::File not used at tests
BuildRequires:  perl(UNIVERSAL/require.pm)
BuildRequires:  perl(version.pm)
BuildRequires:  perl(YAML/Tiny.pm)
Requires:       perl(Algorithm/Dependency/Ordered.pm)
Requires:       perl(Algorithm/Dependency/Source/HoA.pm)
Requires:       perl(CPAN.pm) >= 1.920.500
Requires:       perl(File/Compare.pm)
Requires:       perl(File/Path.pm) >= 2.070
Requires:       perl(File/Temp.pm) >= 0.180
Requires:       perl(LWP/UserAgent.pm)
Requires:       perl(Test/More.pm)
Requires:       perl(Tie/File.pm)

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(File.Path\|File.Temp\).pm)/d

%description
Shipwright is a tool to help you bundle your software with all its dependencies,
regardless of whether they are CPAN modules or non-Perl modules from elsewhere.
Shipwright makes the bundle work easy.

%prep
%setup -q -n Shipwright-%{version}
%patch0 -p1
%patch1 -p1
# Remove bundled modules
rm -rf ./inc
sed -i -e '/^inc\//d' MANIFEST
# Fix shellbangs unnoticed by build script
sed -i -e 's|#!perl|%(perl -MConfig -e 'print $Config{startperl}')|' \
    share/bin/* share/etc/*

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test %{?_smp_mflags}

%files
%doc AUTHORS Changes README TODO
%{_bindir}/shipwright*
%{perl_vendor_privlib}/*

%changelog
