%define module_name Sietima
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Spec.pm) perl(App/Spec/Run.pm) perl(Data/Printer.pm) perl(Digest/SHA.pm) perl(Email/Address.pm) perl(Email/MIME.pm) perl(Email/Sender/Simple.pm) perl(Email/Sender/Transport/Test.pm) perl(Email/Stuffer.pm) perl(ExtUtils/MakeMaker.pm) perl(Import/Into.pm) perl(List/AllUtils.pm) perl(Mail/DMARC/PurePerl.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/Traits.pm) perl(Net/DNS/Resolver/Mock.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/API.pm) perl(Test2/V0.pm) perl(Type/Library.pm) perl(Type/Params.pm) perl(Type/Utils.pm) perl(Types/Path/Tiny.pm) perl(Types/Standard.pm) perl(Types/URI.pm) perl(URI.pm) perl(feature.pm) perl(lib.pm) perl(namespace/clean.pm) perl(strict.pm)
BuildRequires: perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.2
Release: alt1
Summary: minimal mailing list manager
Group: Development/Perl
License: perl
URL: https://www.thenautilus.net/SW/Sietima/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAKKAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sietima is a minimal mailing list manager written in modern Perl. It
aims to be the spiritual successor of the Siesta manpage.

The base `Sietima' class does very little: it just puts the email
message from `STDIN' into a new envelope using the section on "`return_path'"
as sender and all the the section on "`subscribers'" addresses as recipients,
and sends it.

Additional behaviour is provided via traits / roles. This class
consumes the section on "`MooX::Traits'" to simplify composing roles:

  Sietima->with_traits(qw(AvoidDups NoMail))->new(\%%args);

These are the traits provided with the default distribution:

=over 4

=item `AvoidDups'

prevents the sender from receiving copies of their own messages

=item `Debounce'

avoids mail-loops using a `X-Been-There' header

=item `Headers'

adds `List-*' headers to all outgoing messages

=item `ManualSubscription'

specifies that to (un)subscribe, people should write to the list owner

=item `NoMail'

avoids sending messages to subscribers who don't want them

=item `ReplyTo'

optionally sets the `Reply-To' header to the mailing list address

=item `SubjectTag'

prepends a `[tag]' to the subject header of outgoing messages that
aren't already tagged

=item `SubscriberOnly::Drop'

silently drops all messages coming from addresses not subscribed to
the list

=item `SubscriberOnly::Moderate'

holds messages coming from addresses not subscribed to the list for
moderation, and provides commands to manage the moderation queue

=back

The only "configuration mechanism" currently supported is to
initialise a `Sietima' object in your driver script, passing all the
needed values to the constructor. the section on "`Sietima::CmdLine'" is the
recommended way of doing that: it adds command-line parsing capability
to Sietima.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO.md Changes LICENSE example
%perl_vendor_privlib/S*

%changelog
