%define module_name Signer-AWSv4
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(Moo.pm) perl(Test/More.pm) perl(Time/Piece.pm) perl(Type/Tiny.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Implements the AWS v4 signature algorithm
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JL/JLMARTIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Yet Another module to sign requests to Amazon Web Services APIs 
with the AWSv4 signing algorithm. This module has a different twist. The
rest of modules out there are tied to signing HTTP::Request objects, but 
AWS uses v4 signatures in other places: IAM user login to MySQL RDSs, EKS, 
S3 Presigned URLs, etc. When building authentication modules for these services, 
I've had to create artificial HTTP::Request objects, just for a signing module
to sign them, and then retrieve the signature. This module solves that problem,
not being tied to any specific object to sign.

Signer::AWSv4 is a base class that implements the main v4 Algorithm. You're supposed
https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
to subclass and override attributes to adjust how you want the signature to
be built.

It's attributes let you inspect the entire signing process (making the string to
sign, the signature, etc available for inspection)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md examples
%perl_vendor_privlib/S*

%changelog
