# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(IO/Socket/SSL.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(Locale/Country.pm) perl(Module/Build.pm) perl(Mouse.pm) perl(Scalar/Util.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define module_version 0.08
%define module_name SilverGoldBull-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Perl client for the SilverGoldBull(https://silvergoldbull.com/) web service
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOYS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use SilverGoldBull::API;
    use SilverGoldBull::API::BillingAddress;
    use SilverGoldBull::API::ShippingAddress;
    use SilverGoldBull::API::Item;
    use SilverGoldBull::API::Order;

    my $sgb = SilverGoldBull::API->new(api_key => <API_KEY>);#or use SILVERGOLDBULL_API_KEY env variable
    
    #get available currency list
    my $response = $sgb->get_currency_list();
    if ($response->is_success) {
        my $currency_list = $response->data();
    }
    
    my $billing_addr = SilverGoldBull::API::BillingAddress->new({
      'city'       => 'Calgary',
      'first_name' => 'John',
      'region'     => 'AB',
      'email'      => 'sales@silvergoldbull.com',
      'last_name'  => 'Smith',
      'postcode'   => 'T2P 5C5',
      'street'     => '888 - 3 ST SW, 10 FLOOR - WEST TOWER',
      'phone'      => '+1 (403) 668 8648',
      'country'    => 'CA'
    });
    
    my $shipping_addr = SilverGoldBull::API::ShippinggAddress->new({
      'city'       => 'Calgary',
      'first_name' => 'John',
      'region'     => 'AB',
      'email'      => 'sales@silvergoldbull.com',
      'last_name'  => 'Smith',
      'postcode'   => 'T2P 5C5',
      'street'     => '888 - 3 ST SW, 10 FLOOR - WEST TOWER',
      'phone'      => '+1 (403) 668 8648',
      'country'    => 'CA'
    });
    
    my $item = SilverGoldBull::API::Item->new({
        'bid_price' => 468.37,
        'qty'       => 1,
        'id'        => '2706',
    });
    
    my $order_info = {
      "currency"        => "USD",
      "declaration"     => "TEST",
      "shipping_method" => "1YR_STORAGE",
      "payment_method"  => "paypal",
      "shipping"        => $shipping,#or raw hashref
      "billing"         => $billing,#or raw hashref
      "items"           => [$item],#or raw array of hashrefs
    };
    my $order = SilverGoldBull::API::Order->new($order_info);
    my $response = $sgb->create_order($order);
%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE README
%perl_vendor_privlib/S*

%changelog
