# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 2
%define module_name SlideMap_1_2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2
Release: alt1
Summary: Perl module for the creation of MicroArray slide maps
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JW/JWHITE/%{module_name}_%{module_version}.tar.gz
BuildArch: noarch

%description
SlideMap is used to create a row/col -> plate/well map of a microarray 
slide.  It does not as yet incorporate annotation data into the map, 
but simply creates the map object based on input parameters.  The map 
is an ordered list of spots with references to annonymous arrays 
containing array_row, array_col, plate_alias, well.  SlideMap currently 
supports 5 types of arrayers: IAS (default), MD, MD3, Lucidia, and 
Stanford.  (Others will be implemented as needed.)  

SlideMap provides 2 methods for conversion of spots->wells and vise-versa,
based on instantiated parameters.  

The main parameters are: 
machine: _the type of array printing machine used (IAS is the default)
x_pin: __the number of print head pens in the 'X' (plate_row) dimension
y_pin: __the number of print head pens in the 'Y' (plate_col) dimension
___(x_pin = 2, and y_pin = 6 are the defaults)
x_spacing: _the number of spots in one row of a block on the array
y_spacing: _the number of spots in one column of a block on the array
___(x_spacing = 24, and y_spacing = 25 are the defaults)
x_repeat:_the number of repeated block in the 'X' dimension (default = 1)
y_repeat:_the number of repeated block in the 'Y' dimension (default = 1)

The SlideMap module can be used in several ways:
a) 'use' SlideMap, call the constructor with all parameters, and convert 
_spots or wells, fill the map object and loop over it:
_
_use SlideMap;
_$sm->SlideMap->new( machine => "MD3", x_pin => 1, y_pin => 12,
____xspacing => 32, yspacing => 10);
_$ref = $sm->fill_map;
_foreach $row_ref (@$ref)) {
__($row,$col,$plate,$well) = @$row_ref;
__...
_}

b) 'use' SlideMap, call the constructor with minimal parameters, and set 
_parameters individually, then re-initialize and loop over the map:

_use SlideMap;
_$sm->SlideMap->new( machine => "MD3");
_$sm->setBlockDimensions(32,6);
_$ref = $sm->fill_map;
_foreach $row_ref (@$ref)) {
__($row,$col,$plate,$well) = @$row_ref;
__...
_}

c) 'use' SlideMap, call the constructor with machine argument not 
_listed above, set parameters individuzlly, then initialize the 
_map. This is useful for arrayers that are not listed above but 
_operate similarly to one of the above mentioned machines. NOTE:
_default values for parameters are used in this case).
_
_use SlideMap;
_$sm->SlideMap->new(x_pin => 2, y_pin => 12, xspacing => 32, 
__yspacing => 10, machine => 'arrayer');
_$sm->setNoComplement(1);
_$sm->setFormat(1);
_$sm->setPrintDirection(1);
_$sm->setRepeats(1,1);
_$ref = $sm->fill_map;
_foreach $row_ref (@$ref)) {
__($row,$col,$plate,$well) = @$row_ref;
__...
_}

There are several default values associated with each arrayer listed 
above.  They are:

IAS:
Default:
format = 1
print_direction = 0
x_repeat = 1
y_repeat = 1
noComplement = 0

MD3:
format = 2
print_direction = 1
x_repeat = 2
y_repeat = 1
x_spacing = 32
x_pin = 1
y_pin = 12
noComplement = 1

MD:
format = 1
print_direction = 0
x_repeat = 2
y_repeat = 1
yspacing = 16
x_pin = 1
y_pin = 6
noComplement = 1

Stanford:
format = 2
print_direction = 0
x_pin = 4
y_pin = 4
x_repeat = 1
y_repeat = 1
noComplement = 0

Lucidia:
format = 2
print_dir = 1
x_repeat = 1
y_repeat = 1
nocomplement = 0
x_pin = 2
y_pin = 12


%prep
%setup -n SlideMap

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.txt
%perl_vendor_privlib/S*

%changelog
