%define module_name Software-LicenseMoreUtils
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Path/Tiny.pm) perl(Software/License.pm) perl(Software/LicenseUtils.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Text/Template.pm) perl(Try/Tiny.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.009
Release: alt1
Summary: More utilities and a summary for Software::License
Group: Development/Perl
License: perl
URL: https://github.com/dod38fr/Software-LicenseMoreUtils

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DD/DDUMONT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides more utilities for the Software::License manpage:

=over

=item *

Method the new_from_short_name entry elsewhere in this document returns a
the Software::LicenseMoreUtils::LicenseWithSummary manpage object that provides all
functionalities of `Software::License::*' objects and a summary on
some Linux distribution (see below).

=item *

the new_from_short_name entry elsewhere in this document accepts more short names than
the Software::LicenseUtils manpage

=item *

the Software::License::LGPL-2 manpage license is also provided. Even though
license `LGPL-2.1' is preferred over `LGPL-2', some software in
Debian use `LGPL-2'.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes README
%perl_vendor_privlib/S*

%changelog
