# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Section.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/Template.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Software-Security-Policy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Create a Security Policy for your distribution
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TI/TIMLEGGE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a framework for generating a SECURITY.md file to your Perl distributions that will let people know:

=over 4

=item 1. How to contact the maintainers if they find a security issue with your software

=item 2. What software will be supported for security issues

=back

The contact point is very important for modules that have been around for a long time and have had several authors over the years. When there is a long list of maintainers, it's not clear who to contact.

You don't want people reporting security vulnerabilities in public on the RT or GitHub issues for your project, nor do you want a post on IRC, Reddit or social media about it.

If your software is on GitHub, you can set up private vulnerability reporting. GitLab has a similar system.

Otherwise, a single email address is acceptable. An alias that forwards to all of the maintainers or at the very least, a single maintainer who has agreed to that role will work.

It's also important to realise as a maintainer that you are not on your own when you receive a vulnerability report. You are welcome and even encouraged to reach out to CPANSec for assistance triaging and fixing the issue, as well as handling notifications and reporting.

The supported software version may seem obvious, but it's important to spell out: will you be updating only the latest version? What versions of Perl will you support? If your module uses or embeds other libraries, how will they be supported?

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc SECURITY.md README Changes LICENSE
%perl_vendor_privlib/S*

%changelog
