%define module_name Sort-BySpec
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.040
Release: alt1
Summary: Sort array (or create a list sorter) according to specification
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Sort-BySpec

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package provides a more powerful alternative to the Sort::ByExample manpage. Unlike
in `Sort::ByExample` where you only provide a single array of example, you can
specify multiple examples as well as regex or matcher subroutine coupled with
sort rules. With this, you can more precisely specify how elements of your list
should be ordered. If your needs are not met by Sort::ByExample, you might want
to consider this package. The downside is performance penalty, especially when
your list is large.

To sort using Sort::BySpec, you provide a "spec" which is an array of strings,
regexes, or coderefs to match against elements of your list to be sorted. In the
simplest form, the spec contains only a list of examples:

 my $sorter = sort_by_spec(spec => ["foo", "bar", "baz"]); # [1]

and this is equivalent to Sort::ByExample:

 my $sorter = sbe(["foo", "bar", "baz"]);

You can also specify regex to match elements. This is evaluated after strings,
so this work:

 my $sorter = sort_by_spec(spec => [qr/o/, "foo", "bar", "baz", qr/a/]);
 my @list = ("foo", "food", "bar", "back", "baz", "fool", "boat");
 my @res = $sorter->(@list);
 # => ("food","boat","fool",   "foo","bar","baz",   "back")

Right after a regex, you can optionally specify a sort subroutine to tell how to
sort elements matching that regex, for example:

 my $sorter = sort_by_spec(spec => [
     qr/o/ => sub { $_[0] cmp $_[1] },
     "foo", "bar", "baz",
     qr/a/
 ]);

 # the same list @list above will now be sorted into:
 # => ("boat","food","fool",   "foo","bar","baz",   "back")

Note that instead of `$a' and `$b', you should use `$_[0]' and `$_[1]'
respectively. This avoids the package scoping issue of `$a' and `$b', making
your sorter subroutine works everywhere without any special workaround.

Finally, aside from strings and regexes, you can also specify a coderef matcher
for more complex matching:

 my $sorter = sort_by_spec(spec => [
     # put odd numbers first, in ascending order
     sub { $_[0] %% 2 } => sub { $_[0] <=> $_[1] },

     # ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/S*

%changelog
