# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(IO/Socket.pm) perl(IPC/Open2.pm) perl(Sys/Hostname.pm)
# END SourceDeps(oneline)
%define module_version 1.016
%define module_name Spectrum-CLI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.016
Release: alt1
Summary: wrapper class for the Spectrum Command Line Interface
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLONKA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`Spectrum::CLI' is class which intends to provide a convenient way to.invoke the various CLI commands of Spectrum Enterprise Manager from
within perl scripts.

In the author's estimation, the two primary benefits of
`Spectrum::CLI' are:

=over 4

=item * the parsing of "show" command results

`Spectrum::CLI' intelligently parses of the output of CLI "show"
commands.  That is, it will split apart the columnar values for you,
and return them as an array of hashes, each element representing one
line of output.

=item * the elimination of "SpecHex" numbers in scripts

Because of the aforementioned results parsing, it is now easy to
mention spectrum data objects by name rather than by their hexadecimal
Handle or Id.  For instance, the following one=liner will create a hash
of models by model name:

    map { $Model{$_->{MName}} = $_ } Spectrum::CLI->new->show_models;

This would subsequently enable one to refer to a model's handle
like this:

    my $handle = $Model{Universe}{MHandle};

In this way, scripts can be written which discover all SpecHex magic
numbers, and are, therefore, more readable and potentially more
portable/reusable amongst Spectrum installations.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README COPYING Changes
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%files scripts
%_bindir/*
%_man1dir/*
%changelog
