Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Spoon
Version:        0.24
Release:        alt3_52
Summary:        Spiffy Application Building Framework
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Spoon
Source0:        https://cpan.metacpan.org/authors/id/I/IN/INGY/Spoon-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Makefile.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(CGI.pm)
# CGI::Util not used for tests
BuildRequires:  perl(Config.pm)
# Data::Dumper not used for tests
BuildRequires:  perl(DB_File.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(IO/All.pm)
# MIME::Base64 not used for tests
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Spiffy.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Template.pm)
BuildRequires:  perl(Time/HiRes.pm)
# Tests only
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(warnings.pm)
# Optional tests only
BuildRequires:  perl(Test/Memory/Cycle.pm)
Requires:       perl(Carp.pm)
Requires:       perl(CGI/Util.pm)
Requires:       perl(Config.pm)
Requires:       perl(Data/Dumper.pm)
Requires:       perl(Encode.pm)
Requires:       perl(File/Path.pm)
Requires:       perl(IO/All.pm) >= 0.320
Requires:       perl(MIME/Base64.pm)
Requires:       perl(Spiffy.pm) >= 0.240
Requires:       perl(Storable.pm)
Requires:       perl(strict.pm)
Requires:       perl(Template.pm) >= 2.100



Source44: import.info
%filter_from_requires /perl(IO.All\|Spiffy\|Template.pm)/d
%filter_from_provides /perl(IO.All.pm)/d

%description
Spoon is an Application Framework that is designed primarily for
building Social Software web applications. The Kwiki wiki software is
built on top of Spoon.

%prep
%setup -q -n Spoon-%{version}
# Remove bundled modules
rm -r ./inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
