%define module_name Spreadsheet-Compare
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Capture/Tiny.pm) perl(Class/Method/Modifiers.pm) perl(Config.pm) perl(DBI.pm) perl(Encode.pm) perl(Excel/Writer/XLSX.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Log/Log4perl.pm) perl(Module/Load.pm) perl(Mojolicious.pm) perl(Path/Tiny.pm) perl(Pod/Find.pm) perl(Pod/Usage.pm) perl(Spreadsheet/Read.pm) perl(Storable.pm) perl(Test/Exception.pm) perl(Text/CSV.pm) perl(Try/Tiny.pm) perl(YAML/Any.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Module for comparing spreadsheet-like datasets
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Spreadsheet::Compare analyses differences between two similar record sets.
It is designed to be used for regression testing of a large number of files,
databases or spreadsheets.

The record sets can be read from a variety of different sources like CSV files,
fixed column input, databases, Excel or Open/Libre Office Spreadsheets.

The differences can be saved in XLSX or HTML format and are visually highlighted
to allow fast access to the relevant parts.

Configuration of a single comparison, sets of comparisons or whole suites
can be defined as YAML configuration files in order to persist a setup that can be run
multiple times.

Spreadsheet::Compare is the central component normally used by executing the commandline utility
the spreadcomp manpage with a configuration file. It feeds the relevant parts of the configuration data
to the reader, compare and reporting classes.

Reading is done by subclasses of the Spreadsheet::Compare::Reader manpage, The actual comparison is done
by the Spreadsheet::Compare::Single manpage while the reporting output is handled by subclasses of
the Spreadsheet::Compare::Reporter manpage.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE example
%perl_vendor_privlib/S*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
