%define module_name Spreadsheet-Examples
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: A collection of various examples of spreadsheet files
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Spreadsheet-Examples

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution contains, in its share directory, a collection of various
spreadsheet files, usually for testing or benchmarking purposes:

=over

=item * 10sheet-10row-10col

A workbook containing 10 sheets, each sheet containing 10 rows and 10 columns.
The cells are numbers. Minimum formatting.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/10sheet%%2D10row%%2D10col%%2Eods">share/10sheet-10row-10col.ods</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/10sheet%%2D10row%%2D10col%%2Exlsx">share/10sheet-10row-10col.xlsx</a><br />

=end html


=item * 10sheet-1000row-10col

A workbook containing 10 sheets, each sheet containing 1000 rows and 10 columns.
The cells are numbers. Minimum formatting.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/10sheet%%2D1000row%%2D10col%%2Eods">share/10sheet-1000row-10col.ods</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/10sheet%%2D1000row%%2D10col%%2Exlsx">share/10sheet-1000row-10col.xlsx</a><br />

=end html


=item * 10sheet-empty

Empty 10-sheet workbook.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/10sheet%%2Dempty%%2Eods">share/10sheet-empty.ods</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/10sheet%%2Dempty%%2Exlsx">share/10sheet-empty.xlsx</a><br />

=end html


=item * empty

Empty single-sheet workbook.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/empty%%2Eods">share/empty.ods</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/Spreadsheet-Examples-0.003/share/empty%%2Exlsx">share/empty.xlsx</a><br />

=end html


=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%changelog
