%define module_name Spreadsheet-GenerateXLSX
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Excel/Writer/XLSX.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Ref/Util.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Warn.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: function to generate XLSX spreadsheet from array ref(s)
Group: Development/Perl
License: perl
URL: https://github.com/neilb/Spreadsheet-GenerateXLSX

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEILB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a function `generate_xlsx' which takes
an array of Perl data and generates a simple Excel spreadsheet
in the XLSX format.
The generated sheets have the first row frozen,
and auto filters enabled for every column.

Each sheet in the spreadsheet is generated from an array of rows,
where each row is an arrayref.
The first row is treated as a header row.
Here's an example:

 my @sheet1 = (
    ['Pokemon',  'Type',      'Number'],
    ['Pikachu',  'Electric',  25],
    ['Vulpix',   'Fire',      37],
    ['Ditto',    'Normal',    132],
 );

The generated spreadsheet can have any numbers of sheets:

 generate_xslx('pokemon.xlsx', \@sheet1, \@sheet2);

If you just pass arrayrefs, the sheets will be named Sheet1, Sheet2, etc.
You can also pass the name of the sheet:

 generate_xslx('pokemon.xlsx', 'All Pokemon' => \@sheet1, 'Hit List' => \@sheet2);
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/S*

%changelog
