%define module_name Spreadsheet-ReadGnumeric
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(PerlIO/gzip.pm) perl(XML/Parser/Lite.pm) perl(YAML/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4
Release: alt1
Summary: turn a Gnumeric file into a Spreadsheet::Read data structure
Group: Development/Perl
License: perl
URL: https://git.sr.ht/~rgrjr/Spreadsheet-ReadGnumeric

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGRJR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Given a source of saved Gnumeric data, `Spreadsheet::ReadGnumeric'
parses it and returns the result in the same format as
`Spreadsheet::Read'.  In fact, `Spreadsheet::Read' has a few more
bells and whistles, such as transposing the resulting sheets and
providing an object-oriented interface to the resulting data, so it
may be easier to access this module through `Spreadsheet::Read', even
if you only want to parse Gnumeric data.

Note that Gnumeric only saves raw cell values, and not their
formatted versions.  In particular, Gnumeric saves expressions, and not
expression values, never mind formatted expression values.
Even the expressions are sometimes encoded in a way
that `Spreadsheet::ReadGnumeric' cannot not completely unparse, so
the returned data structure will look less well populated than the
spreadsheet does in Gnumeric.  See the "ExprID" TODO item below.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/S*

%changelog
