# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Tiny.pm) perl(Encode.pm) perl(Module/Build/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(bignum.pm)
# END SourceDeps(oneline)
%define module_name Sqids
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: generate short unique identifiers from numbers
Group: Development/Perl
License: mit
URL: https://github.com/sqids/sqids-perl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MY/MYSOCIETY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sqids (*pronounced "squids"*) is a small
library that lets you generate unique IDs from numbers. It's good for link
shortening, fast & URL-safe ID generation and decoding back into numbers for
quicker database lookups.

Features:

=over 4

=item * Encode multiple numbers - generate short IDs from one or several non-negative numbers

=item * Quick decoding - easily decode IDs back into numbers

=item * Unique IDs - generate unique IDs by shuffling the alphabet once

=item * ID padding - provide minimum length to make IDs more uniform

=item * URL safe - auto-generated IDs do not contain common profanity

=item * Randomized output - Sequential input provides nonconsecutive IDs

=item * Many implementations - Support for 40+ programming languages

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/S*

%changelog
